//
//  WXKAppDelegate.m
//  AnotherKyoponUtilities
//
//  Created by FUJIDANA on 06/08/23.
//  Copyright 2006 FUJIDANA. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#import "WXKAppDelegate.h"
#import "WXKPhone.h"

NSString *WXKDefaultsAllowsLaunchingWithoutDriverKey = @"AllowsLaunchingWithoutDriver";


@implementation WXKAppDelegate

+ (void)initialize
{
    NSUserDefaults	*defaults			= [NSUserDefaults standardUserDefaults];
	
    NSDictionary	*appDefaults		= [NSDictionary dictionaryWithObject:[NSNumber numberWithBool:NO] forKey:WXKDefaultsAllowsLaunchingWithoutDriverKey];
    [defaults registerDefaults:appDefaults];
}

#pragma mark Methods delegated by NSApplication

- (void)applicationWillFinishLaunching:(NSNotification *)aNotification
{
	if ([FJDCoreDataAppDelegate instancesRespondToSelector:@selector(applicationWillFinishLaunching:)]) {
		[super applicationWillFinishLaunching:aNotification];
	}
	
	// --- Check whether driver is already installed. If driver is not found, quit application. ---
	
	NSUserDefaults *userDefaults = [NSUserDefaults standardUserDefaults];
	
	if ([userDefaults boolForKey:WXKDefaultsAllowsLaunchingWithoutDriverKey] == NO && [WXKPhone existsDriver] == NO) {
	
		NSString *driverName  = [WXKPhone requiredDriverName];
		NSString *message     = NSLocalizedString(@"Couldn't use this application because the %@ didn't exist.", @"driverNotFoundAlert.message");
		NSString *information = NSLocalizedString(@"You need to install the %@ or later. The application will be quited.", @"driverNotFoundAlert.information");
	
		NSAlert *alert = [[[NSAlert alloc] init] autorelease];
		[alert addButtonWithTitle:NSLocalizedString(@"Quit", @"driverNotFoundAlert.firstButton")];
		[alert setMessageText:[NSString stringWithFormat:message, driverName]];
		[alert setInformativeText:[NSString stringWithFormat:information, driverName]];
		[alert setAlertStyle:NSCriticalAlertStyle];
		[alert runModal];
		[NSApp terminate:self];
	}
}


- (void)applicationDidFinishLaunching:(NSNotification *)aNotification
{
	if ([FJDCoreDataAppDelegate instancesRespondToSelector:@selector(applicationDidFinishLaunching:)]) {
		[super applicationDidFinishLaunching:aNotification];
	}
	
	[addressWindowController window];
	[bookmarkWindowController window];
	[mailWindowController window];
	[fileWindowController window];
	[addressWindowController showWindow:nil];
	[bookmarkWindowController showWindow:nil];
	[mailWindowController showWindow:nil];
	[fileWindowController showWindow:nil];
	
}

// --- Invoked when application icon in Dock is cliked or application icon in Finder is double clicked. ---
	
- (BOOL)applicationShouldHandleReopen:(NSApplication *)theApplication hasVisibleWindows:(BOOL)flag
{
	
	if ([FJDCoreDataAppDelegate instancesRespondToSelector:@selector(applicationShouldHandleReopen:hasVisibleWindows:)]) {
		if ([super applicationShouldHandleReopen:theApplication hasVisibleWindows:flag] == NO) {
			return NO;
		}
	}
	
	// --- If no window is visible, display main window. ---
	
	if (flag == NO) {
		NSEnumerator *enumerator = [[self registeredPersistentWindowControllers] objectEnumerator];
		id coreDataWindowController;
		while (coreDataWindowController = [enumerator nextObject]) {
			[coreDataWindowController showWindow:nil];
		}
	}
	return YES;
}


#pragma mark Action methods

- (IBAction)launchAddressUtility:(id)sender
{
	if (addressWindowController != nil) {
	
		[addressWindowController showWindow:sender];
		
	} else if ([[NSWorkspace sharedWorkspace] launchAppWithBundleIdentifier:@"jp.sourceforge.kyoponutilities.KyoponAddressUtility"
																	options:NSWorkspaceLaunchDefault
											 additionalEventParamDescriptor:nil
														   launchIdentifier:NULL] == NO && 
			   [[NSWorkspace sharedWorkspace] launchApplication:@"Kyopon Address Utility"] == NO) {
	
		NSString *appName		= NSLocalizedString(@"Kyopon Address Utility", @"addressUtility.fullAppName");
		NSString *message		= NSLocalizedString(@"%@ cannot be launched.", @"failToLaunchRelatedUtilityAlert.message");
		NSString *information	= NSLocalizedString(@"%@ might not be installed, renamed, or moved into the trash.", @"failToLaunchRelatedUtilityAlert.information");
		
		NSAlert *alert = [[[NSAlert alloc] init] autorelease];
		[alert setMessageText:[NSString stringWithFormat:message, appName]];
		[alert setInformativeText:[NSString stringWithFormat:information, appName]];
		[alert setAlertStyle:NSWarningAlertStyle];
		[alert runModal];
	}
}

- (IBAction)launchBookmarkUtility:(id)sender
{
	if (bookmarkWindowController != nil) {
	
		[bookmarkWindowController showWindow:sender];
		
	} else {
		if ([[NSWorkspace sharedWorkspace] launchAppWithBundleIdentifier:@"jp.sourceforge.kyoponutilities.KyoponBookmarkUtility"
																 options:NSWorkspaceLaunchDefault
										  additionalEventParamDescriptor:nil
														launchIdentifier:NULL]) {
			return;
		}
		
		NSWorkspace		*workspace			= [NSWorkspace sharedWorkspace];
		NSFileManager	*fileManager		= [NSFileManager defaultManager];
		
		NSString		*bookmarkAppName	= @"Kyopon Bookmark Utility";
		
		NSString		*dataFolderPath		= [[[NSHomeDirectory() stringByAppendingPathComponent:@"Library"]
			stringByAppendingPathComponent:@"Application Support"]
			stringByAppendingPathComponent:@"AH-K3001V Utilities"];
		NSString		*filePath			= [dataFolderPath stringByAppendingPathComponent:@"Bookmarks.airh-bookmarks"];
		NSString		*localizedFilePath	= [dataFolderPath stringByAppendingPathComponent:NSLocalizedString(@"Bookmarks.airh-bookmarks", nil)];
		
		if ([fileManager fileExistsAtPath:localizedFilePath] && [workspace openFile:localizedFilePath withApplication:bookmarkAppName]) {
			return;
		} else if ([fileManager fileExistsAtPath:filePath] && [workspace openFile:filePath withApplication:bookmarkAppName]) {
			return;
		} else if ([workspace launchApplication:bookmarkAppName]) {
			return;
		} else {
			NSString *appName		= NSLocalizedString(@"Kyopon Bookmark Utility", @"bookmarkUtility.fullAppName");
			NSString *message		= NSLocalizedString(@"%@ cannot be launched.", @"failToLaunchRelatedUtilityAlert.message");
			NSString *information	= NSLocalizedString(@"%@ might not be installed, renamed, or moved into the trash.", @"failToLaunchRelatedUtilityAlert.information");
			
			NSAlert *alert = [[[NSAlert alloc] init] autorelease];
			[alert setMessageText:[NSString stringWithFormat:message, appName]];
			[alert setInformativeText:[NSString stringWithFormat:information, appName]];
			[alert setAlertStyle:NSWarningAlertStyle];
	//		[alert setIcon:<#(NSImage *)icon#>];
			[alert runModal];
		}
	}
}

- (IBAction)launchFileUtility:(id)sender
{
	if (fileWindowController != nil) {
	
		[fileWindowController showWindow:nil];
		
	} else if ([[NSWorkspace sharedWorkspace] launchAppWithBundleIdentifier:@"jp.sourceforge.kyoponutilities.KyoponFileUtility"
																	options:NSWorkspaceLaunchDefault
											 additionalEventParamDescriptor:nil
														   launchIdentifier:NULL] == NO && 
			   [[NSWorkspace sharedWorkspace] launchApplication:@"Kyopon File Utility"] == NO) {
				   
				   NSString *appName		= NSLocalizedString(@"Kyopon File Utility", @"fileUtility.fullAppName");
		NSString *message		= NSLocalizedString(@"%@ cannot be launched.", @"failToLaunchRelatedUtilityAlert.message");
		NSString *information	= NSLocalizedString(@"%@ might not be installed, renamed, or moved into the trash.", @"failToLaunchRelatedUtilityAlert.information");
		
		NSAlert *alert = [[[NSAlert alloc] init] autorelease];
		[alert setMessageText:[NSString stringWithFormat:message, appName]];
		[alert setInformativeText:[NSString stringWithFormat:information, appName]];
		[alert setAlertStyle:NSWarningAlertStyle];
//		[alert setIcon:<#(NSImage *)icon#>];
		[alert runModal];
	}
}

- (IBAction)launchMailUtility:(id)sender
{
	if (mailWindowController != nil) {
	
		[mailWindowController showWindow:nil];
		
	} else if ([[NSWorkspace sharedWorkspace] launchAppWithBundleIdentifier:@"jp.sourceforge.kyoponutilities.KyoponMailUtility"
																	options:NSWorkspaceLaunchDefault
											 additionalEventParamDescriptor:nil
														   launchIdentifier:NULL] == NO && 
				[[NSWorkspace sharedWorkspace] launchApplication:@"Kyopon Mail Utility"] == NO) {
	
		NSString *appName		= NSLocalizedString(@"Kyopon Mail Utility", @"mailUtility.fullAppName");
		NSString *message		= NSLocalizedString(@"%@ cannot be launched.", @"failToLaunchRelatedUtilityAlert.message");
		NSString *information	= NSLocalizedString(@"%@ might not be installed, renamed, or moved into the trash.", @"failToLaunchRelatedUtilityAlert.information");
		
		NSAlert *alert = [[[NSAlert alloc] init] autorelease];
		[alert setMessageText:[NSString stringWithFormat:message, appName]];
		[alert setInformativeText:[NSString stringWithFormat:information, appName]];
		[alert setAlertStyle:NSWarningAlertStyle];
//		[alert setIcon:<#(NSImage *)icon#>];
		[alert runModal];
	}
}

@end
